<?php
namespace Newland\Toubiz\Sync\Neos\Translation;

use Doctrine\ORM\Mapping as ORM;
use Newland\Toubiz\Api\Constants\Language;

trait TranslatableEntity
{

    /**
     * @var string|null
     * @ORM\Column(type="string", options={"fixed" = true}, length=2, nullable=true)
     */
    protected $language;

    /**
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }

    public function setLanguage(string $language = null)
    {
        if ($language) {
            Language::throwIfInvalid($language);
        }
        $this->language = $language;
    }
}
