<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock;

use Newland\Toubiz\Api\ObjectAdapter\EventAdapterInterface;

class EventAdapterMock implements EventAdapterInterface
{

    public $properties = [];

    public function __construct(array $properties)
    {
        $this->properties = $properties;
    }

    public function getName()
    {
        return $this->properties['name'] ?? '';
    }

    public function getDescription()
    {
        return $this->properties['description'] ?? '';
    }

    public function getAdditionalInformation()
    {
        return $this->properties['additionalInformation'] ?? '';
    }

    public function getBeginsAt()
    {
        return $this->properties['beginsAt'] ?? new \DateTime();
    }

    public function getEndsAt()
    {
        return $this->properties['endsAt'] ?? new \DateTime();
    }

    public function getAdmission()
    {
        return $this->properties['admission'] ?? '';
    }

    public function getIsHighlight()
    {
        return $this->properties['isHighlight'] ?? false;
    }

    public function getIsTipp()
    {
        return $this->properties['isTipp'] ?? null;
    }

    public function getTicketUri()
    {
        return $this->properties['ticketUri'] ?? null;
    }

    public function getTicketContact()
    {
        return $this->properties['ticketContact'] ?? null;
    }

    public function getLink()
    {
        return $this->properties['link'] ?? null;
    }

    public function getUpdatedAt()
    {
        return $this->properties['updatedAt'] ?? new \DateTime();
    }

    public function getCategories()
    {
        return $this->properties['categories'] ?? [];
    }

    public function getEventDates()
    {
        return $this->properties['eventDates'] ?? [];
    }

    public function getEventTags()
    {
        return $this->properties['eventTags'] ?? [];
    }

    public function getAttributes()
    {
        return $this->properties['attributes'] ?? [];
    }

    public function getMedia()
    {
        return $this->properties['media'] ?? [];
    }

    public function getOrganizer()
    {
        return $this->properties['organizer'] ?? null;
    }

    public function getLocation()
    {
        return $this->properties['location'] ?? null;
    }

    public function getSourceName()
    {
        return $this->properties['sourceName'] ?? '';
    }

    public function getScope(): int
    {
        return $this->properties['scope'] ?? -1;
    }

    public function getLanguage()
    {
        return $this->properties['language'] ?? null;
    }

    public function getExternalId(): string
    {
        return $this->properties['externalId'] ?? '';
    }
}
