<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\Weather;
use Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock\WeatherAdapterMock;

class WeatherFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $weather = new Weather();

        $weather->setUpdatedAt($properties['updatedAt'] ?? new \DateTime());
        $weather->setData($properties['data'] ?? new WeatherAdapterMock([]));
        $weather->setLocation($properties['location'] ?? $this->faker->city);
        $weather->setOriginalId($properties['originalId'] ?? $this->faker->uuid);

        return $weather;
    }
}
