<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\Medium;

class MediaFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $media = new Medium();

        $media->setSourceUri($properties['sourceUri'] ?? $this->faker->imageUrl());
        $media->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $media->setTitle($properties['title'] ?? $this->faker->words(3, true));
        $media->setCopyright($properties['copyright'] ?? $this->faker->paragraph);

        return $media;
    }
}
