<?php
namespace Newland\Toubiz\Sync\Neos\Geometry;

use CrEOF\Spatial\PHP\Types\AbstractGeometry;
use CrEOF\Spatial\PHP\Types\Geometry\LineString;
use CrEOF\Spatial\PHP\Types\Geometry\MultiLineString;
use CrEOF\Spatial\PHP\Types\Geometry\MultiPoint;
use CrEOF\Spatial\PHP\Types\Geometry\MultiPolygon;
use CrEOF\Spatial\PHP\Types\Geometry\Point;
use CrEOF\Spatial\PHP\Types\Geometry\Polygon;
use GeoIO\Dimension;
use GeoIO\Factory;

/**
 * Factory for object of the creof/doctrine2-spatial package.
 */
class CreofDoctrineSpatialFactory implements Factory
{

    public function create(
        string $type,
        array $properties,
        $dimension = Dimension::DIMENSION_2D,
        $srid = null
    ) {
        switch ($type) {
            case AbstractGeometry::POINT:
                return $this->createPoint($dimension, $properties, $srid);
            case AbstractGeometry::LINESTRING:
                return $this->createLineString($dimension, $properties, $srid);
            case AbstractGeometry::POLYGON:
                return $this->createPolygon($dimension, $properties, $srid);
            case AbstractGeometry::MULTIPOINT:
                return $this->createMultiPoint($dimension, $properties, $srid);
            case AbstractGeometry::MULTILINESTRING:
                return $this->createMultiLineString($dimension, $properties, $srid);
            case AbstractGeometry::MULTIPOLYGON:
                return $this->createMultiPolygon($dimension, $properties, $srid);
            default:
                return null;
        }
    }

    public function createPoint($dimension, array $coordinates, $srid = null)
    {
        return new Point($coordinates);
    }

    public function createLineString($dimension, array $points, $srid = null)
    {
        return new LineString($points);
    }

    public function createPolygon($dimension, array $lineStrings, $srid = null)
    {
        return new Polygon($lineStrings);
    }

    public function createMultiPoint($dimension, array $points, $srid = null)
    {
        return new MultiPoint($points);
    }

    public function createMultiLineString($dimension, array $lineStrings, $srid = null)
    {
        return new MultiLineString($lineStrings);
    }

    public function createMultiPolygon($dimension, array $polygons, $srid = null)
    {
        return new MultiPolygon($polygons);
    }

    public function createLinearRing($dimension, array $points, $srid = null)
    {
        return null;
    }

    public function createGeometryCollection($dimension, array $geometries, $srid = null)
    {
        return null;
    }
}
