<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Repository;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\QueryBuilder;
use Neos\Cache\Frontend\FrontendInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Cache\CacheManager;
use Newland\Toubiz\Api\ObjectAdapter\WeatherAdapterInterface;
use Newland\Toubiz\Sync\Neos\Domain\Filter\FilterInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\Weather;

/**
 * Weather repository.
 *
 * @Flow\Scope("singleton")
 *
 * @method Weather|null findOneByOriginalId(string $originalId)
 * @method Weather|null findOneByLocation(string $location)
 * @method Weather|null findByIdentifier(string $identifier)
 * @method Weather|null findOneBy(array $criteria, array $orderBy = null)
 */
class WeatherRepository extends AbstractRepository
{

    public function findAllCities(): array
    {

        $query = $this->createQueryBuilder('weather');

        $query = $query->select('weather.location as location');
        $cities = $query->getQuery()
            ->getScalarResult();

        $data = [];
        foreach ($cities as $city) {
            $data[] = $city['location'];
        }
        return $data;
    }

    protected function applyFilter(FilterInterface $filter, QueryBuilder $query): QueryBuilder
    {
        $this->applyBasicFilter($filter, $query);
        return $query;
    }
}
