<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model\RelatedLists;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

class RelatedLists
{
    /**
     * @var EntityList
     */
    protected $poiHighlights;

    /**
     * @var EntityList[]
     */
    protected $entityLists = [];

    public function __construct()
    {
        $this->poiHighlights = new EntityList();
    }

    public function getPoiHighlights(): EntityList
    {
        return $this->poiHighlights;
    }

    public function setPoiHighlights(EntityList $poiHighlights): void
    {
        $this->poiHighlights = $poiHighlights;
    }

    /**
     * @return EntityList[]
     */
    public function getEntityLists(): array
    {
        return $this->entityLists;
    }

    public function setEntityLists(array $entityLists): void
    {
        $this->entityLists = $entityLists;
    }

    public function addEntityList(EntityList $entityList): void
    {
        $this->entityLists[] = $entityList;
    }
}
