<?php
namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Service;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Tests\UnitTestCase;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Service\UuidPredictionService;

class UuidPredictionServiceTest extends UnitTestCase
{
    /**
     * @var UuidPredictionService
     */
    protected $subject;

    public function setUp()
    {
        $this->subject = new UuidPredictionService();

        $this->subject->setDefaultProperties(
            [
                'language' => 'de',
                'client' => '',
                'mainType' => ArticleConstants::TYPE_ATTRACTION,
            ]
        );
    }

    public function testPredictionForEntities(): void
    {
        $this->assertEquals('004a4468-10a2-5159-a266-df842ff316a5', $this->subject->predict('article', 'd6e27f5fbbdfc463889af0abdb4666ba'));
        $this->assertEquals('021923fc-40b8-5fcf-9a5d-96b3aef9e69a', $this->subject->predict('category', 'd786796b78426be18fea385a55f02ef8'));
    }

    public function testPredictionSameAsManualGeneration(): void
    {
        $article = new Article();
        $article->setOriginalId('d6e27f5fbbdfc463889af0abdb4666ba');
        $article->setMainType(ArticleConstants::TYPE_ATTRACTION);
        $article->setLanguage('de');

        $this->assertEquals($article->generateUuid()->toString(), $this->subject->predict('article', 'd6e27f5fbbdfc463889af0abdb4666ba'));
    }
}
