<?php
namespace Neos\Flow\Persistence\Doctrine\Migrations;

use Doctrine\Migrations\AbstractMigration;
use Doctrine\DBAL\Schema\Schema;

/**
 * Auto-generated Migration: Please modify to your needs! This block will be used as the migration description if getDescription() is not used.
 */
class Version20190613045253 extends AbstractMigration
{

    /**
     * Indicates the transactional mode of this migration.
     * If this function returns true (default) the migration will be executed in one transaction,
     * otherwise non-transactional state will be used to execute each of the migration SQLs.
     *
     * Extending class should override this function to alter the return value
     *
     * @return bool TRUE by default.
     */
    public function isTransactional()
    {
        return false;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return '';
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function up(Schema $schema)
    {
        // this up() migration is autogenerated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() != 'mysql', 'Migration can only be executed safely on "mysql".');

        $this->addSql('SET FOREIGN_KEY_CHECKS=0');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_address CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE mainaddress mainaddress CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_addresses_join CHANGE neos_article neos_article CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE neos_address neos_address CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_categories_join CHANGE neos_article neos_article CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE neos_category neos_category CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_media_join CHANGE neos_article neos_article CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE neos_medium neos_medium CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_article_files_join CHANGE neos_article neos_article CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE neos_file neos_file CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_attribute CHANGE article article CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_benefit CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE package package CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_category CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE location location CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:guid)\', CHANGE organizer organizer CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_categories_join CHANGE neos_event neos_event CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE neos_category neos_category CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_eventtags_join CHANGE neos_event neos_event CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE neos_eventtag neos_eventtag CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_event_media_join CHANGE neos_event neos_event CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE neos_medium neos_medium CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_eventdate CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE event event CHAR(36) DEFAULT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_eventtag CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_file CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_medium CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_offer CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_package CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_package_media_join CHANGE neos_package neos_package CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE neos_medium neos_medium CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_region CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_region_transportation_facilities_join CHANGE neos_region neos_region CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE neos_transportationfacility neos_transportationfacility CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_region_slopes_join CHANGE neos_region neos_region CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\', CHANGE neos_slope neos_slope CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_slope CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');
        $this->addSql('ALTER TABLE newland_toubiz_sync_neos_domain_model_transportationfacility CHANGE persistence_object_identifier persistence_object_identifier CHAR(36) NOT NULL COMMENT \'(DC2Type:guid)\'');

        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_address', 'import_ident', 'newland_toubiz_sync_neos_address_import_ident', [ 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_article', 'import_ident', 'newland_toubiz_sync_neos_article_import_ident', [ 'language', 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_benefit', 'import_ident', 'newland_toubiz_sync_neos_benefit_import_ident', [ 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_file', 'import_ident', 'newland_toubiz_sync_neos_file_import_ident', [ 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_region', 'import_ident', 'newland_toubiz_sync_neos_region_import_ident', [ 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_keyvalue', 'identifier', 'newland_toubiz_sync_neos_keyvalue_identifier', [ 'identifier' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_slope', 'import_ident', 'newland_toubiz_sync_neos_slope_import_ident', [ 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_transportationfacility', 'import_ident', 'newland_toubiz_sync_neos_transportationfacility_import_ident', [ 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_medium', 'import_ident', 'newland_toubiz_sync_neos_medium_import_ident', [ 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_offer', 'import_ident', 'newland_toubiz_sync_neos_offer_import_ident', [ 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_package', 'import_ident', 'newland_toubiz_sync_neos_package_import_ident', [ 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_category', 'import_ident', 'newland_toubiz_sync_neos_category_import_ident', [ 'language', 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_event', 'import_ident', 'newland_toubiz_sync_neos_event_import_ident', [ 'language', 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_eventdate', 'import_ident', 'newland_toubiz_sync_neos_eventdate_import_ident', [ 'language', 'originalid' ]);
        $this->renameIndexIfExists('newland_toubiz_sync_neos_domain_model_eventtag', 'import_ident', 'newland_toubiz_sync_neos_eventtag_import_ident', [ 'language', 'originalid' ]);
        $this->addSql('SET FOREIGN_KEY_CHECKS=1');
    }

    /**
     * @param Schema $schema
     * @return void
     */
    public function down(Schema $schema)
    {
        $this->abortIf(true, 'This migration is not reversable');
    }

    private function renameIndexIfExists(string $table, string $before, string $after, array $columns)
    {
        if ($this->indexExists($table, $before)) {
            $this->addSql(sprintf('DROP INDEX %s ON %s', $table, $before));
        }
        if (!$this->indexExists($table, $after)) {
            $this->addSql(sprintf('CREATE INDEX %s ON %s (%s)', $after, $table, implode(', ', $columns)));
        }
    }

    private function indexExists(string $table, string $indexName): bool
    {
        foreach ($this->sm->listTableIndexes($table) as $index) {
            if ($index->getName() === $indexName) {
                return true;
            }
        }
        return false;
    }
}
