<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Newland\Toubiz\Sync\Neos\Domain\Model\EventTag;

class EventTagFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $tag = new EventTag();

        $tag->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $tag->setKeyword($properties['keyword'] ?? $this->faker->word);
        if (array_key_exists('language', $properties)) {
            $tag->setLanguage($properties['language']);
        }

        return $tag;
    }
}