<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Filter;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Event filter class.
 */
class EventFilter extends AbstractFilter
{
    /**
     * @var string
     */
    protected const DATE_FORMAT = 'Y-m-d';

    /**
     * @var \DateTime|null
     */
    protected $fromDate;

    /**
     * @var \DateTime|null
     */
    protected $toDate;

    /**
     * @var string|null
     */
    protected $categoryIdentifier;

    /**
     * @var bool|null
     */
    protected $highlight;

    /**
     * Initializes filter options.
     *
     * @param array $config
     * @return self
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        if (array_key_exists('date', $config)) {
            $this->fromDate = $this->parseDate($config['date']);
        } elseif (array_key_exists('dateRange', $config)) {
            $this->fromDate = $this->parseDate($config['dateRange']['from']);
            $this->toDate = $this->parseDate($config['dateRange']['to']);
        }
        if (array_key_exists('fromDate', $config)) {
            $this->setFromDate($config['fromDate']);
        }
        if (array_key_exists('toDate', $config)) {
            $this->setToDate($config['toDate']);
        }
        if (array_key_exists('category', $config)) {
            $this->categoryIdentifier = $config['category'];
        }

        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getFromDate()
    {
        return $this->fromDate;
    }

    /**
     * @param \DateTime $date
     * @return self
     */
    public function setFromDate(\DateTime $date)
    {
        $this->fromDate = $date;
        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getToDate()
    {
        return $this->toDate;
    }

    /**
     * @param \DateTime $date
     * @return self
     */
    public function setToDate(\DateTime $date)
    {
        $this->toDate = $date;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCategory()
    {
        return $this->categoryIdentifier;
    }

    /**
     * @return bool|null
     */
    public function getHighlight()
    {
        return $this->highlight;
    }

    /**
     * @param bool|null $highlight
     * @return self
     */
    public function setHighlight($highlight)
    {
        $this->highlight = $highlight;
        return $this;
    }

    /**
     * Helper to parse dates.
     *
     * @param string $date
     * @return \DateTime|null
     */
    protected function parseDate(string $date)
    {
        return \DateTime::createFromFormat(self::DATE_FORMAT, $date) ?: null;
    }
}
