<?php declare(strict_types=1);


namespace Newland\Toubiz\Sync\Neos\Tests\Factory;


use Newland\Toubiz\Sync\Neos\Domain\Model\Event;

class EventFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $event = new Event();

        $event->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $event->setTitle($properties['title'] ?? $this->faker->title);
        $event->setDescription($properties['description'] ?? $this->faker->paragraph);
        $event->setAdditionalInformation($properties['additionalInformation'] ?? $this->faker->paragraph);
        $event->setAdmission($properties['admission'] ?? $this->faker->paragraph);
        $event->setIsHighlight($properties['isHighlight'] ?? $this->faker->boolean);
        $event->setIsTipp($properties['isTipp'] ?? $this->faker->boolean);
        $event->setBeginsAt($properties['beginsAt'] ?? $this->faker->dateTime);
        $event->setEndsAt($properties['endsAt'] ?? $this->faker->dateTime);
        $event->setTicketUri($properties['ticketUri'] ?? $this->faker->url);
        $event->setTicketContact($properties['ticketContact'] ?? $this->faker->name);
        $event->setLink($properties['link'] ?? $this->faker->url);
        $event->setUpdatedAt($properties['updatedAt'] ?? $this->faker->dateTime);

        return $event;
    }
}