<?php declare(strict_types=1);


namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Faker\Factory as FakerFactory;
use Faker\Generator;
use Neos\Flow\ObjectManagement\ObjectManager;
use Neos\Flow\ObjectManagement\ObjectManagerInterface;
use Neos\Flow\Persistence\PersistenceManagerInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;

class ArticleFactory extends AbstractFactory
{

    public function make(array $properties = [])
    {
        $article = new Article();

        $article->setOriginalId($properties['originalId'] ?? $this->faker->uuid);
        $article->setMainType($properties['mainType'] ?? random_int(0, 5));
        $article->setName($properties['name'] ?? $this->faker->name);
        $article->setAbstract($properties['abstract'] ?? $this->faker->text);
        $article->setDescription($properties['description'] ?? $this->faker->text);
        $article->setClient($properties['client'] ?? $this->faker->word);

        $article->setFacebookUri($properties['facebookUri'] ?? $this->faker->url);
        $article->setInstagramUri($properties['instagramUri'] ?? $this->faker->url);
        $article->setYoutubeUri($properties['youtubeUri'] ?? $this->faker->url);
        $article->setFlickrUri($properties['flickrUri'] ?? $this->faker->url);
        $article->setWikipediaUri($properties['wikipediaUri'] ?? $this->faker->url);
        $article->setBookingUri($properties['bookingUri'] ?? $this->faker->url);
        $article->setDetailUri($properties['detailUri'] ?? null);
        $article->setStarClassification($properties['starClassification'] ?? random_int(0, 5));
        $article->setAverageRating($properties['averageRating'] ?? random_int(0, 100));
        $article->setNumberOfRatings($properties['numberOfRatings'] ?? random_int(0, 100000));
        $article->setUpdatedAt($properties['updatedAt'] ?? new \DateTime());

        $article->setSourceName($properties['sourceName'] ?? $this->faker->name);
        $article->setAuthorName($properties['authorName'] ?? $this->faker->name);

        if (array_key_exists('openingTimes', $properties)) {
            $article->setOpeningTimes($properties['openingTimes']);
        }
        if (array_key_exists('openingTimesFormat', $properties)) {
            $article->setOpeningTimesFormat($properties['openingTimesFormat']);
        }

        // TODO relations

        return $article;
    }

}