<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Importer;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Importer\PackageImporter;
use Newland\Toubiz\Sync\Neos\Tests\Unit\Importer\Mock\PackageAdapterMock;

class PackageImporterTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var PackageImporter */
    private $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = new PackageImporter();
        $this->subject->setClient('foobar');
    }

    public function testImportsMedia()
    {
        $adapter = new PackageAdapterMock();
        $adapter->previewImage = 'https://foobar.com/image.jpg';
        $package = $this->subject->import($adapter);

        $this->assertCount(1, $package->getMedia());
        $this->assertEquals('https://foobar.com/image.jpg', $package->getMedia()->first()->getSourceUri());
    }

    public function testDoesNotImportMediaIfNoMediaExists()
    {
        $adapter = new PackageAdapterMock();
        $adapter->previewImage = null;
        $package = $this->subject->import($adapter);

        $this->assertCount(0, $package->getMedia());
    }

}