<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Factory;

use Faker\Generator;
use Neos\Flow\ObjectManagement\ObjectManagerInterface;
use Neos\Flow\Persistence\PersistenceManagerInterface;
use Faker\Factory as FakerFactory;

abstract class AbstractFactory
{

    /** @var Generator */
    protected $faker;

    /** @var PersistenceManagerInterface */
    protected $persistenceManager;

    /** @var ObjectManagerInterface */
    protected $objectManager;

    public function __construct(ObjectManagerInterface $objectManager, ?Generator $faker = null)
    {
        $this->objectManager = $objectManager;
        $this->persistenceManager = $objectManager->get(PersistenceManagerInterface::class);
        $this->faker = $faker ?? FakerFactory::create();
    }

    public function create(array $properties = [])
    {
        $article = $this->make($properties);
        $this->persistenceManager->add($article);
        $this->persistenceManager->persistAll();
        return $article;
    }

    abstract public function make(array $properties = []);

}