<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Domain\Model;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Article;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ArticleRepository;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ArticleFactory;

class ArticleTest extends FunctionalTestCase
{
    public static $testablePersistenceEnabled = true;

    /** @var Article */
    protected $article;

    /** @var Article */
    protected $fromDatabase;

    public function setUp()
    {
        parent::setUp();

        $factory = new ArticleFactory($this->objectManager);
        $this->article = $factory->create();

        /** @var ArticleRepository $repository */
        $repository = $this->objectManager->get(ArticleRepository::class);
        $this->fromDatabase = $repository->find($this->article->getPersistenceObjectIdentifier());
    }

    public function testCorrectlySavesBasicColumn(): void
    {
        $this->assertInstanceOf(Article::class, $this->fromDatabase);

        // Note: Not using data provider like a normal person to prevent overhead of setting up &
        //       tearing down the db for every tested column.
        foreach ($this->basicColumnsDataProvider() as [ $columnName ]) {
            $getter = 'get' . ucfirst($columnName);
            $this->assertTrue(
                method_exists($this->article, $getter),
                sprintf('Article should have method %s',  $getter)
            );
            $this->assertTrue(
                method_exists($this->fromDatabase, $getter),
                sprintf('Article from db should have method %s',  $getter)
            );
            $this->assertEquals(
                $this->article->{$getter}(),
                $this->fromDatabase->{$getter}(),
                sprintf('Column %s (getter %s) should be the same after retrieving from database', $columnName, $getter)
            );
        }
    }

    public function basicColumnsDataProvider(): array
    {
        return [
            [ 'mainType' ],
            [ 'name' ],
            [ 'abstract' ],
            [ 'description' ],
            [ 'client' ],
            [ 'facebookUri' ],
            [ 'instagramUri' ],
            [ 'youtubeUri' ],
            [ 'flickrUri' ],
            [ 'wikipediaUri' ],
            [ 'bookingUri' ],
            [ 'detailUri' ],
            [ 'starClassification' ],
            [ 'averageRating' ],
            [ 'numberOfRatings' ],
            [ 'updatedAt' ],
            [ 'sourceName' ],
            [ 'authorName' ],
        ];
    }

}