<?php
namespace Newland\Toubiz\Sync\Neos\Importer;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\Flow\Cache\CacheManager;
use Newland\Toubiz\Sync\Neos\Domain\Repository\WeatherRepository;

/**
 * Weather importer.
 *
 * This does not fit the rest of the importers as its data
 * is not directly bound to a model nor is the data stored
 * in the database. The whole weather modelling is pragmatic
 * and needs more work in the future!
 *
 * @Flow\Scope("singleton")
 */
class WeatherImporter extends AbstractImporter
{
    /**
     * @Flow\Inject
     * @var WeatherRepository
     */
    protected $weatherRepository;

    /**
     * Import method.
     *
     * Persist given data by creating new objects or updating existing ones.
     * This takes the whole data response array and stores it in one
     * cache file. Thus, no object adapter exists yet, where data converting
     * should happen instead of the importer itself.
     *
     * @param array $data
     * @return void
     */
    public function import($data)
    {
        $keys = [
            'dd' => 'windDirection',
            'ff' => 'windSpeed',
            'fx' => 'maximumWindGust',
            'rr' => 'rainPrecipitation',
            'rrp' => 'rainProbability',
            'sl' => 'snowfallLine',
            'ss' => 'sunshineDuration',
            'sy' => 'symbol',
            'tn' => 'minimumTemperature',
            'tt' => 'temperature',
            'tx' => 'maximumTemperature'
        ];

        foreach ($data as $city => $dateArray) {
            foreach ($dateArray as $date => $records) {
                foreach ($keys as $oldKey => $newKey) {
                    $this->renameArrayKey(
                        $data[$city][$date],
                        $oldKey,
                        $newKey
                    );
                }
            }
        }
        $this->weatherRepository->store('forecast', $data);
    }

    /**
     * Helper method to rename short array keys to human readable ones.
     *
     * @param array &$array
     * @param string $oldKey
     * @param string $newKey
     * @return void
     */
    protected function renameArrayKey(&$array, $oldKey, $newKey)
    {
        if (!array_key_exists($oldKey, $array)) {
            return;
        }

        $array[$newKey] = $array[$oldKey];
        unset($array[$oldKey]);
    }
}
