<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

 use Doctrine\ORM\Mapping as ORM;
 use Neos\Flow\Annotations as Flow;

/**
 * A feature.
 *
 * @Flow\Entity
 */
class Feature extends AbstractEntity
{
    /**
     * @ORM\ManyToMany(targetEntity="\Newland\Toubiz\Sync\Neos\Domain\Model\Article", mappedBy="features", fetch="LAZY")
     * @var Collection
     */
    protected $articles;

    /**
     * @var string
     */
    protected $name;

    /**
     * @param string $name
     * @return void
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
}
