<?php
namespace Newland\Toubiz\Sync\Neos\Command;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\Service\ServiceFactory;
use Newland\Toubiz\Sync\Neos\Importer\WeatherImporter;

/**
 * Weather command controller.
 *
 * Provides commands to manipulate weather data.
 *
 * @Flow\Scope("singleton")
 */
class WeatherCommandController extends AbstractCommandController
{
    /**
     * @Flow\InjectConfiguration
     * @var array
     */
    protected $configuration;

    /**
     * Synchronize command.
     *
     * Updates local weather data from API data source.
     *
     * @return void
     */
    public function synchronizeCommand()
    {
        // There is currently only one API providing weather data.
        $configuration = $this->getConfigurationForService('Meteotest/Api');
        if (!$configuration) {
            throw new \Exception('Meteotest/Api service not configured!');
        }

        $service = ServiceFactory::get('Meteotest/Api');
        $service->setAction($configuration['action']);
        $service->setApiKey($configuration['apiKey']);

        $forecast = $service->fetchForecast();
        $importer = new WeatherImporter;
        $importer->import($forecast);
    }
}
