<?php
namespace Newland\Toubiz\Sync\Neos\Importer;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\ObjectAdapter\RegionAdapterInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\Region;
use Newland\Toubiz\Sync\Neos\Domain\Repository\RegionRepository;

/**
 * Region importer.
 *
 * @Flow\Scope("singleton")
 */
class RegionImporter extends AbstractImporter
{
    /**
     * @Flow\Inject
     * @var RegionRepository
     */
    protected $regionRepository;

    /**
     * Import method.
     *
     * Persist given data by creating new objects or updating existing ones.
     *
     * @param RegionAdapterInterface $data
     * @return Region
     */
    public function import($data)
    {
        $region = $this->regionRepository->findOneByOriginalId($data->getExternalId());
        $persisted = !!$region;

        if (!$region) {
            $region = new Region;
        }

        if (!$region->getOriginalId()) {
            $region->setOriginalId($data->getExternalId());
        }

        $region->setName($data->getName());

        if ($persisted) {
            $this->regionRepository->update($region);
        } else {
            $this->regionRepository->add($region);
        }

        $this->persistenceManager->persistAll();
        return $region;
    }
}
