<?php
namespace Newland\Toubiz\Sync\Neos\Importer;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Api\ObjectAdapter\EventFeatureAdapterInterface;
use Newland\Toubiz\Sync\Neos\Domain\Model\Feature;
use Newland\Toubiz\Sync\Neos\Domain\Repository\FeatureRepository;

/**
 * Feature importer.
 *
 * @Flow\Scope("singleton")
 */
class FeatureImporter extends AbstractImporter
{
    /**
     * @Flow\Inject
     * @var FeatureRepository
     */
    protected $featureRepository;

    /**
     * Import method.
     *
     * Persist given data by creating new objects or updating existing ones.
     *
     * @param EventFeatureAdapterInterface $data
     * @return Feature
     */
    public function import($data)
    {
        $feature = $this->featureRepository->findOneByOriginalId($data->getExternalId());
        $persisted = !!$feature;

        if (!$feature) {
            $feature = new Feature;
        }

        if (!$feature->getOriginalId()) {
            $feature->setOriginalId($data->getExternalId());
        }
        $feature->setName($data->getName());

        if ($persisted) {
            $this->featureRepository->update($feature);
        } else {
            $this->featureRepository->add($feature);
        }

        // Persisting is required due to the API returning the same object multiple times!
        $this->persistenceManager->persistAll();

        return $feature;
    }
}
