<?php
namespace Newland\Toubiz\Sync\Neos\Domain\Repository;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\QueryBuilder;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Persistence\QueryResultInterface;
use Newland\Toubiz\Sync\Neos\Domain\Filter\ArticleFilter;

/**
 * Article repository.
 *
 * @Flow\Scope("singleton")
 */
class ArticleRepository extends AbstractRepository
{
    /**
     * Find articles matching given filter.
     *
     * TODO refactor into abstract
     *
     * @param ArticleFilter $filter
     * @return QueryResultInterface
     */
    public function findByFilter(ArticleFilter $filter)
    {
        $query = $this->createQueryBuilder('article');
        $this->applyFilter($filter, $query);

        return $query->getQuery()->execute();
    }

    /**
     * Applies filter functions (from the article filter) onto
     * the given query builder.
     *
     * @param ArticleFilter $filter
     * @param QueryBuilder $query
     * @return void
     */
    protected function applyFilter(ArticleFilter $filter, QueryBuilder $query)
    {
        parent::applyBasicFilter($filter, $query);

        // Category is always joined as e.g. sorting relies on it.
        $query->leftJoin('article.categories', 'category');

        if ($filter->hasMainType()) {
            $query->andWhere(
                $query->expr()->eq('article.mainType', $filter->getMainType())
            );
        }
        if ($filter->hasCategories()) {
            $query->andWhere(
                $query->expr()->in('category', $filter->getCategories())
            );
        }
        if ($filter->hasLatitude()) {
            $query->andWhere(
                $query->expr()->like(
                    'article.latitude',
                    $query->expr()->literal($filter->getLatitude() . '%')
                )
            );
        }
        if ($filter->hasLongitude()) {
            $query->andWhere(
                $query->expr()->like(
                    'article.longitude',
                    $query->expr()->literal($filter->getLongitude() . '%')
                )
            );
        }
    }
}
