<?php declare(strict_types=1);

namespace Newland\Toubiz\SnowReport\Tests\Integration;

use Newland\Toubiz\Poi\Neos\Tests\Integration\IntegrationTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Region;
use Newland\Toubiz\Sync\Neos\Domain\Model\TransportationFacility;
use Newland\Toubiz\Sync\Neos\Tests\Factory\RegionFactory;
use Newland\Toubiz\Sync\Neos\Tests\Factory\TransportationFacilityFactory;

class RegionDetailTest extends IntegrationTestCase
{

    /** @var Region */
    protected $region;

    public function setUp(): void
    {
        parent::setUp();
        $this->node->setNodeType($this->nodeTypeManager->getNodeType('Newland.Toubiz.SnowReport.Neos:Full'));

        $this->region = (new RegionFactory($this->objectManager))->create([
            'transportationFacilities' => [
                (new TransportationFacilityFactory($this->objectManager))->create([ 'name' => '__FACILITY_1__' ]),
                (new TransportationFacilityFactory($this->objectManager))->create([ 'name' => '__FACILITY_2__' ]),
                (new TransportationFacilityFactory($this->objectManager))->create([ 'name' => '__FACILITY_3__' ]),
            ],
        ]);
    }

    public function testDisplaysTransportationFacilities(): void
    {
        $url = $this->nodeUri([
            '--newland_toubiz_snowreport_neos-full' => [
                '@action' => 'show',
                'region' => [ '__identity' => $this->region->getPersistenceObjectIdentifier() ]
            ]
        ]);

        $response = $this->browser->request($url);
        $this->assertResponseOk($response);

        $this->assertResponseContains('__FACILITY_1__', $response);
        $this->assertResponseContains('__FACILITY_2__', $response);
        $this->assertResponseContains('__FACILITY_3__', $response);
    }

}
