<?php
namespace Newland\Toubiz\SnowReport\Neos\ViewHelpers\Widget;

/*
 * This file is part of the "toubiz-snowreport-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetViewHelper;
use Newland\Toubiz\SnowReport\Neos\ViewHelpers\Widget\Controller\RegionStatusController;

/**
 * Renders the region status widget.
 */
class RegionStatusViewHelper extends AbstractWidgetViewHelper
{
    /**
     * @Flow\Inject
     * @var RegionStatusController
     */
    protected $controller;

    /**
     * Render this view helper.
     *
     * @param string $regions Comma-separated list of regions to render.
     * @param NodeInterface $node The current node.
     * @return string
     */
    public function render($regions, NodeInterface $node)
    {
        $response = $this->initiateSubRequest();
        return $response->getContent();
    }
}
