<?php
namespace Newland\Toubiz\SnowReport\Neos\ViewHelpers\Widget\Controller;

/*
 * This file is part of the "toubiz-snowreport-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Newland\Toubiz\Sync\Neos\Domain\Model\Region;
use Newland\Toubiz\Sync\Neos\Domain\Repository\RegionRepository;
use Newland\Toubiz\Sync\Neos\Domain\Repository\SlopeRepository;
use Newland\Toubiz\Sync\Neos\Domain\Repository\TransportationFacilityRepository;

/**
 * The widget controller for the region status widget.
 */
class RegionStatusController extends AbstractWidgetController
{
    /**
     * @Flow\Inject
     * @var RegionRepository
     */
    protected $regionRepository;

    /**
     * @Flow\Inject
     * @var SlopeRepository
     */
    protected $slopeRepository;

    /**
     * @Flow\Inject
     * @var TransportationFacilityRepository
     */
    protected $transportationFacilityRepository;

    /**
     * Main action for this widget.
     *
     * @return void
     */
    public function indexAction()
    {
        $regions = $this->regionRepository->findByIdentifiers($this->widgetConfiguration['regions']);

        if ($regions) {
            $this->view->assignMultiple([
                'regionNames' => $this->getRegionNames($regions),
                'statistics' => [
                    'facilities' => $this->transportationFacilityRepository->getStatistics($regions),
                    'slopes' => $this->slopeRepository->getStatistics($regions)
                ]
            ]);
        }

        if (\count($regions) === 1) {
            $this->view->assign('region', $regions[0]);
        }

        $targetNode = $this->getTargetNode();
        if ($targetNode) {
            $this->view->assign('targetNode', $targetNode);
        }
    }

    /**
     * Finds the page node type that contains the full plugin.
     *
     * @return Node|null
     */
    protected function getTargetNode()
    {
        $site = $this->widgetConfiguration['node']->getContext()->getCurrentSiteNode();

        $query = new FlowQuery([$site]);
        return $query->find('[instanceof Newland.Toubiz.SnowReport.Neos:Full]')
                     ->parents('[instanceof Neos.NodeTypes:Page]')
                     ->get(0);
    }

    /**
     * Extract the region names
     *
     * @param Region[] $regions
     * @return string[]
     */
    protected function getRegionNames(array $regions): array
    {
        return array_map(
            function (Region $region) {
                return $region->getName();
            },
            $regions
        );
    }
}
