<?php
namespace Newland\Toubiz\SnowReport\Neos\ViewHelpers\Math;

/*
 * This file is part of the "toubiz-snowreport-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Circle math view helper.
 *
 * Calculates values for filling an svg circle.
 */
class CircleViewHelper extends AbstractViewHelper
{

    public function initializeArguments(): void
    {
        $this->registerArgument('base', 'float', null, true);
        $this->registerArgument('current', 'float', null, true);
        $this->registerArgument('total', 'float', null, true);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): float {
        $percentage = 100 / $arguments['total'] * $arguments['current'];
        return $arguments['base'] * (1 - ($percentage / 100));
    }
}
