<?php
namespace Newland\Toubiz\SnowReport\Neos\ViewHelpers\Mapping;

/*
 * This file is part of the "toubiz-snowreport-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

/**
 * Abstract class to simplify mapping raw data.
 * Useful for mapping int values to css classes, etc.
 *
 * Extend and overwrite $map as needed ('from' => 'to').
 */
abstract class BaseMappingViewHelper extends AbstractViewHelper
{
    protected static $map = [''];

    public function initializeArguments(): void
    {
        $this->registerArgument('value', 'string', null, false, null);
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ) {
        $value = $arguments['value'] ?? 0;
        return static::$map[$value] ?? static::$map[0];
    }
}
