<?php
namespace Newland\Toubiz\SnowReport\Neos\ViewHelpers\Math;

/*
 * This file is part of the "toubiz-snowreport-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Circle math view helper.
 *
 * Calculates values for filling an svg circle.
 */
class CircleViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param float $base
     * @param float $current
     * @param float $total
     * @return float
     */
    public function render($base, $current, $total)
    {
        $percentage = 100 / $total * $current;
        return $base * (1 - ($percentage / 100));
    }
}
