<?php
namespace Newland\Toubiz\SnowReport\Neos\ViewHelpers\Mapping;

/*
 * This file is part of the "toubiz-snowreport-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;

/**
 * Abstract class to simplify mapping raw data.
 * Useful for mapping int values to css classes, etc.
 *
 * Extend and overwrite $map as needed ('from' => 'to').
 */
abstract class BaseMappingViewHelper extends AbstractViewHelper
{
    /** @var array<int, string> */
    protected static $map = [ 0 => '' ];

    /**
     * @return string
     */
    public function render(string $value = null)
    {
        // use default value if no or invalid value is given
        $value = $value ?? 0;
        $value = array_key_exists($value, $this::$map) ? $value : 0;

        return static::$map[$value];
    }
}
