<?php
namespace Newland\Toubiz\SnowReport\Neos\ViewHelpers\Icon;

/*
 * This file is part of the "toubiz-snowreport-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\Toubiz\Api\ObjectAdapter\Concern\TransportationFacilityConstants as Facility;

/**
 * Transportation facility icon view helper.
 *
 * Renders an icon for a facility based on an identifier. Also contains
 * logic to simplify the views.
 */
class TransportationFacilityViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param int $type
     * @return string
     */
    public function render($type)
    {
        switch ($type) {
            case Facility::TYPE_COGWHEEL_RAILWAY:
                $name = 'cog-railway';
                break;

            default:
                $name = 'lift';
                break;
        }

        return '<svg class="c-icon"><use xlink:href="#tb-snowreport-icon-' . $name . '"></use></svg>';
    }
}
