<?php
namespace Newland\Toubiz\SnowReport\Neos\ViewHelpers\Widget\Controller;

/*
 * This file is part of the "toubiz-snowreport-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Eel\FlowQuery\FlowQuery;
use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\Widget\AbstractWidgetController;
use Neos\ContentRepository\Domain\Model\NodeInterface;
use Newland\Toubiz\Sync\Neos\Domain\Repository\RegionRepository;
use Newland\Toubiz\Sync\Neos\Domain\Repository\SlopeRepository;
use Newland\Toubiz\Sync\Neos\Domain\Repository\TransportationFacilityRepository;

/**
 * The widget controller for the region status widget.
 */
class RegionStatusController extends AbstractWidgetController
{
    /**
     * @Flow\Inject
     * @var RegionRepository
     */
    protected $regionRepository;

    /**
     * @Flow\Inject
     * @var SlopeRepository
     */
    protected $slopeRepository;

    /**
     * @Flow\Inject
     * @var TransportationFacilityRepository
     */
    protected $transportationFacilityRepository;

    /**
     * Main action for this widget.
     *
     * @return void
     */
    public function indexAction()
    {
        $region = $this->regionRepository->find(
            $this->widgetConfiguration['region']
        );

        if ($region) {
            $this->view->assignMultiple([
                'region' => $region,
                'statistics' => [
                    'facilities' => $this->transportationFacilityRepository->getStatistics([$region]),
                    'slopes' => $this->slopeRepository->getStatistics([$region])
                ]
            ]);
        }

        $targetNode = $this->getTargetNode();
        if ($targetNode) {
            $this->view->assign('targetNode', $targetNode);
        }
    }

    /**
     * Finds the page node type that contains the full plugin.
     *
     * @return Node|null
     */
    protected function getTargetNode()
    {
        $site = $this->widgetConfiguration['node']->getContext()->getCurrentSiteNode();

        $query = new FlowQuery([$site]);
        return $query->find('[instanceof Newland.Toubiz.SnowReport.Neos:Full]')
                     ->parents('[instanceof Neos.NodeTypes:Page]')
                     ->get(0);
    }
}
