<?php
namespace Newland\Toubiz\SnowReport\Neos\ViewHelpers\Icon;

/*
 * This file is part of the "toubiz-snowreport-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use Newland\Toubiz\Api\ObjectAdapter\Concern\SlopeConstants as Slope;

/**
 * Slope icon view helper.
 *
 * Renders an icon for a slope based on an identifier. Also contains
 * logic to simplify the views.
 */
class SlopeViewHelper extends AbstractViewHelper
{
    /**
     * Main method.
     *
     * @param int $type
     * @return string
     */
    public function render($type)
    {
        switch ($type) {
            case Slope::TYPE_SKI:
                $name = 'ski-slope';
                break;

            case Slope::TYPE_SLED_TRAIL:
                $name = 'sled';
                break;

            case Slope::TYPE_HIKING_TRAIL:
                $name = 'hiking';
                break;

            case Slope::TYPE_SNOWSHOE_HIKING_TRAIL:
                $name = 'snow-shoe';
                break;

            default:
                $name = 'snow-flake';
                break;
        }

        return '<svg class="c-icon"><use xlink:href="#tb-snowreport-icon-' . $name . '"></use></svg>';
    }
}
