<?php
namespace Newland\Toubiz\SnowReport\Neos\DataSource;

/*
 * This file is part of the "toubiz-snowreport-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Neos\Service\DataSource\AbstractDataSource;
use Newland\Toubiz\Sync\Neos\Domain\Repository\RegionRepository;


/**
 * Regions data source service.
 *
 * @Flow\Scope("singleton")
 */
class RegionsDataSource extends AbstractDataSource
{
    /**
     * @var string Data source identifier.
     */
    static protected $identifier = 'newland-toubiz-snowreport-neos-regions';

    /**
     * @Flow\Inject
     * @var RegionRepository
     */
    protected $regionRepository;

    /**
     * Get requested data from source.
     *
     * The return value must be JSON serializable data structure.
     *
     * @api
     * @param NodeInterface $node The node that is currently edited (optional)
     * @param array $arguments Additional arguments (key / value)
     * @return mixed JSON serializable data
     */
    public function getData(NodeInterface $node = null, array $arguments = [])
    {
        $regions = $this->regionRepository->findAll();

        $data = [];
        foreach ($regions as $region) {
            $data[] = [
                'label' => $region->getName(),
                'value' => $region->getPersistenceObjectIdentifier()
            ];
        }

        sort($data);
        return $data;
    }
}
