<?php declare(strict_types=1);

namespace Newland\Toubiz\Services\Neos\Tests\Unit\ViewHelpers\Format;

use Newland\Toubiz\Services\Neos\Tests\Unit\ViewHelpers\ViewHelperTestCase;

class DurationToHoursViewHelpersTest extends ViewHelperTestCase
{

    /** @dataProvider provideMinutes */
    public function testRendersCorrectlyFromArguments(int $minutes, string $expected): void
    {
        $this->view->setTemplateSource(sprintf('<services:format.durationToHours minutes="%s" />', $minutes));
        $this->assertEquals($expected, $this->view->render());
    }

    /** @dataProvider provideMinutes */
    public function testRendersCorrectlyFromContents(int $minutes, string $expected): void
    {
        $this->view->setTemplateSource(
            sprintf(
                '<services:format.durationToHours>%s</services:format.durationToHours>',
                $minutes
            )
        );
        $this->assertEquals($expected, $this->view->render());
    }

    public function provideMinutes(): array
    {
        return [
            [ 42, '0:42' ],
            [ 120, '2:00' ],
            [ 1200, '20:00' ],
            [ 90, '1:30' ],
            [ 65, '1:05' ],
        ];
    }
}
