<?php declare(strict_types=1);

namespace Newland\Toubiz\Services\Neos\Unit\LinkHandler;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Services\Neos\LinkHandler\ServiceLinkHandler;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ServiceFactory;

class ServiceLinkHandlerTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var ServiceLinkHandler */
    protected $subject;

    /** @var ServiceFactory */
    protected $serviceFactory;

    public function setUp(): void
    {
        parent::setUp();
        $this->subject = $this->objectManager->get(ServiceLinkHandler::class);
        $this->serviceFactory = new ServiceFactory($this->objectManager);
    }

    public function testFindsServiceByIdentifier(): void
    {
        $service = $this->serviceFactory->create();
        $record = $this->subject->findByIdentifier($service->getPersistenceObjectIdentifier());
        $this->assertEquals($service->getPersistenceObjectIdentifier(), $record->getId());
    }

    public function testFindsServicesBySearchTerm(): void
    {
        $match = $this->serviceFactory->create([ 'name' => 'foobar trainrid' ]);
        $noMatch = $this->serviceFactory->create([ 'name' => 'does not match' ]);

        $result = $this->subject->findBySearchTerm('foo');
        $this->assertCount(1, $result);

        $this->assertEquals($match->getPersistenceObjectIdentifier(), $result[0]->getId());
        $this->assertNotEquals($noMatch->getPersistenceObjectIdentifier(), $result[0]->getId());
    }
}
