<?php
namespace Newland\Toubiz\Services\Neos\ViewHelpers\Format;

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;

class DurationToHoursViewHelper extends AbstractViewHelper
{
    public function render(int $minutes = null, string $separator = ':'): string
    {
        $minutes = $minutes ?? $this->renderChildren();

        $hours = floor($minutes / 60);
        $minutes -= $hours * 60;
        $minutesPadded = str_pad((string) $minutes, 2, '0', STR_PAD_LEFT);

        return $hours . $separator . $minutesPadded;
    }
}
