<?php declare(strict_types=1);

namespace Newland\Toubiz\Services\Neos\Unit\DataSource;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ServiceConstants;
use Newland\Toubiz\Services\Neos\DataSource\ServiceDataSource;
use Newland\Toubiz\Sync\Neos\Domain\Model\Service;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ServiceFactory;

class ServiceDataSourceTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    /** @var ServiceFactory */
    protected $serviceFactory;

    /** @var ServiceDataSource */
    protected $subject;

    public function setUp(): void
    {
        parent::setUp();
        $this->serviceFactory = new ServiceFactory($this->objectManager);
        $this->subject = $this->objectManager->get(ServiceDataSource::class);
    }

    public function testFindsAllService(): void
    {
        $services = $this->createServicesOfAllTypes();
        $data = $this->subject->getData(null, []);

        $this->assertCount(\count($services), $data);
    }

    /** @dataProvider provideTypes */
    public function testFindsServicesByType(string $type): void
    {
        $services = $this->createServicesOfAllTypes();

        $data = $this->subject->getData(null, [ 'type' => $type ]);
        $this->assertCount(3, $data);

        $ids = array_map(
            function ($item) {
                return $item['value'];
            },
            $data
        );
        foreach ($services as $service) {
            if ($service->getType() === $type) {
                $this->assertContains($service->getPersistenceObjectIdentifier(), $ids);
            } else {
                $this->assertNotContains($service->getPersistenceObjectIdentifier(), $ids);
            }
        }
    }

    public function provideTypes(): array
    {
        return array_map(
            function (string $type) {
                return [ $type ];
            },
            ServiceConstants::ALL_TYPES
        );
    }

    /** @return Service[] */
    private function createServicesOfAllTypes(): array
    {
        $services = [ [] ];
        // Create 3 services of each type
        foreach (ServiceConstants::ALL_TYPES as $typeToCreate) {
            $services[] = $this->serviceFactory->createMultiple(3, [ 'type' => $typeToCreate ]);
        }
        return array_merge(...$services);
    }

}
