<?php declare(strict_types=1);

namespace Newland\Toubiz\Services\Neos\Tests\Integration\Teaser;

use Newland\NeosTestingHelpers\IntegrationTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Service;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ServiceFactory;

abstract class TeaserTestCase extends IntegrationTestCase
{

    abstract protected function type(): string;

    /** @var Service */
    protected $service;

    public function setUp(): void
    {
        parent::setUp();

        $this->service = (new ServiceFactory($this->objectManager))->create([ 'type' => $this->type() ]);

        $this->node->setNodeType($this->nodeTypeManager->getNodeType('Newland.Toubiz.Services.Neos:Teaser'));
        $this->node->setProperty('service', $this->service->getPersistenceObjectIdentifier());
        $this->persistNode($this->node);
    }

    public function testShouldContainName(): void
    {
        $this->service->setName('__SOME_NAME_HERE__');
        $this->persistenceManager->update($this->service);
        $this->persistenceManager->persistAll();

        $response = $this->browser->request($this->nodeUri());
        $this->assertResponseOk($response);
        $this->assertResponseContains('__SOME_NAME_HERE__', $response);
    }

    public function testShouldContainBenefits(): void
    {
        $this->service->setBenefits([ '__BENEFIT_1__', '__BENEFIT_2__', '__BENEFIT_3__' ]);
        $this->persistenceManager->update($this->service);
        $this->persistenceManager->persistAll();

        $response = $this->browser->request($this->nodeUri());
        $this->assertResponseOk($response);
        $this->assertResponseContains('__BENEFIT_1__', $response);
        $this->assertResponseContains('__BENEFIT_2__', $response);
        $this->assertResponseContains('__BENEFIT_3__', $response);
    }
}
