<?php declare(strict_types=1);

namespace Newland\Toubiz\Services\Neos\LinkHandler;

use Newland\NeosCommon\LinkHandler\Domain\Model\Record;
use Newland\Toubiz\Sync\Neos\Domain\Model\Service;

class ServiceRecord extends Record
{
    /** @var Service */
    protected $service;

    public function __construct(Service $service)
    {
        $this->service = $service;
        $this->id = (string) $service->getPersistenceObjectIdentifier();
        $this->title = $service->getName();
    }

    public function getService(): Service
    {
        return $this->service;
    }
}
