<?php declare(strict_types=1);

namespace Newland\Toubiz\Services\Neos\Unit\Eel\Helper;

use Neos\ContentRepository\Domain\Model\Node;
use Neos\Flow\Tests\FunctionalTestCase;
use Newland\NeosTestingHelpers\CompilesFusion;
use Newland\NeosTestingHelpers\InteractsWithNodes;
use Newland\Toubiz\Sync\Neos\Domain\Model\Service;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ServiceFactory;

class ServiceHelperTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;
    use CompilesFusion, InteractsWithNodes;

    /** @var Node */
    protected $siteNode;

    public function setUp(): void
    {
        parent::setUp();

        $site = $this->initializeSite('foobar');
        $this->siteNode = $this->initializeNode('/sites/foobar', 'live', $site);
    }

    public function testFindsServiceById(): void
    {
        $service = (new ServiceFactory($this->objectManager))->create();
        $result = $this->compileFusion(
            $this->siteNode,
            '${Newland.Toubiz.Service.findByIdentifier(id)}',
            [ 'id' => $service->getPersistenceObjectIdentifier() ]
        );

        $this->assertInstanceOf(Service::class, $result);
        $this->assertEquals($service->getPersistenceObjectIdentifier(), $result->getPersistenceObjectIdentifier());
    }

    public function testGeneratesUrlForService(): void
    {
        $service = (new ServiceFactory($this->objectManager))->create();
        $result = $this->compileFusion(
            $this->siteNode,
            '${Newland.Toubiz.Service.url(service)}',
            compact('service')
        );

        $this->assertEquals($service->getDetailUrl(), $result);
    }

    public function testDoesNotFailGeneratingUrlWhenNoServiceGiven(): void
    {
        $result = $this->compileFusion(
            $this->siteNode,
            '${Newland.Toubiz.Service.url(null)}'
        );

        $this->assertNull($result);
    }

}
