<?php
namespace Newland\Toubiz\Services\Neos\ViewHelpers\Link;

/*
 * This file is part of the "toubiz-sync-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Neos\Flow\Annotations as Flow;
use Neos\FluidAdaptor\Core\ViewHelper\AbstractTagBasedViewHelper;
use Newland\Toubiz\Services\Neos\Service\ServiceUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Service;

class ServiceViewHelper extends AbstractTagBasedViewHelper
{

    /**
     * @var ServiceUrlService
     * @Flow\Inject()
     */
    protected $serviceUrlService;

    protected $tagName = 'a';

    public function initializeArguments(): void
    {
        $this->registerUniversalTagAttributes();
        parent::initializeArguments();
    }

    public function render(?Service $service): string
    {
        if ($service !== null) {
            $this->tag->addAttribute(
                'href',
                $this->serviceUrlService->generateUrl($service) ?? '#'
            );
        }

        $this->tag->setContent($this->renderChildren());
        return $this->tag->render();
    }
}
