<?php declare(strict_types=1);

namespace Newland\Toubiz\Services\Neos\Tests\Unit\ViewHelpers\Link;

use Newland\Toubiz\Services\Neos\Tests\Unit\ViewHelpers\ViewHelperTestCase;
use Newland\Toubiz\Sync\Neos\Domain\Model\Service;

class ServiceViewHelperTest extends ViewHelperTestCase
{

    public function testUsesUrlOfService(): void
    {
        $service = new Service();
        $service->setDetailUrl('https://foobar.com');

        $this->view->assign('service', $service);
        $this->view->setTemplateSource(
            '<services:link.service service="{service}">Test content</services:link.service>'
        );

        $result = $this->view->render();
        $this->assertContains('href="https://foobar.com"', $result);
        $this->assertContains('Test content', $result);
    }

}
