<?php declare(strict_types=1);

namespace Newland\Toubiz\Services\Neos\Unit\LinkHandler;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Services\Neos\LinkHandler\ServiceRecord;
use Newland\Toubiz\Sync\Neos\Tests\Factory\ServiceFactory;

class ServiceRecordTest extends FunctionalTestCase
{
    protected static $testablePersistenceEnabled = true;

    public function testExtractsDataFromService(): void
    {
        $service = (new ServiceFactory($this->objectManager))->create();
        $record = new ServiceRecord($service);

        $this->assertEquals($service->getName(), $record->getTitle());
        $this->assertEquals($service->getPersistenceObjectIdentifier(), $record->getId());
        $this->assertEquals($service, $record->getService());
    }

}
