<?php declare(strict_types=1);

namespace Newland\Toubiz\Services\Neos\Tests\Unit\ViewHelpers\Format;

use Newland\Toubiz\Services\Neos\Tests\Unit\ViewHelpers\ViewHelperTestCase;

class CurrencyViewHelperTest extends ViewHelperTestCase
{

    /** @dataProvider provideCurrencyData */
    public function testFormatsCurrenciesFromChildren(float $price, string $currency, string $expected): void
    {
        $this->view->setTemplateSource(
            sprintf(
                '<services:format.currency currencyCode="%s">%s</services:format.currency>',
                $currency,
                $price
            )
        );
        $this->assertEquals($expected, $this->view->render());
    }

    public function provideCurrencyData(): array
    {
        return [
            'Euro' => [ 42000.1, 'EUR', '42.000,10 €' ],
            'Swiss Franc' => [ 42000.1, 'CHF', '42&#039;000.10 CHF' ],
            'Pound' => [ 42000.1, 'GBP', '42,000.10 £' ],
            'Dollar' => [ 42000.1, 'USD', '$ 42,000.10' ],
            'Fallback' => [ 42000.1, 'ABC', '42.000,10 ABC' ],
        ];
    }
}
