<?php
namespace Newland\Toubiz\Services\Neos\ViewHelpers\Format;

use Neos\FluidAdaptor\Core\ViewHelper\AbstractViewHelper;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\Traits\CompileWithRenderStatic;

class DurationToHoursViewHelper extends AbstractViewHelper
{
    use CompileWithRenderStatic;

    public function initializeArguments(): void
    {
        $this->registerArgument(
            'minutes',
            'integer',
            'Number of minutes to display',
            false,
            null
        );
        $this->registerArgument(
            'separator',
            'string',
            'Separator between hours & minutes',
            false,
            ':'
        );
    }

    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): string {
        $minutes = $arguments['minutes'] ?? (int) $renderChildrenClosure();
        $separator = $arguments['separator'];

        $hours = floor($minutes / 60);
        $minutes -= $hours * 60;
        $minutes = str_pad((string) $minutes, 2, '0', STR_PAD_LEFT);

        return $hours . $separator . $minutes;
    }
}
