<?php declare(strict_types=1);

namespace Newland\Toubiz\Services\Neos\Eel\Helper;

use Neos\Eel\ProtectedContextAwareInterface;
use Neos\Flow\Annotations as Flow;
use Newland\Toubiz\Services\Neos\Service\ServiceUrlService;
use Newland\Toubiz\Sync\Neos\Domain\Model\Service;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ServiceRepository;

class ServiceHelper implements ProtectedContextAwareInterface
{

    /**
     * @var ServiceRepository
     * @Flow\Inject()
     */
    protected $serviceRepository;

    /**
     * @var ServiceUrlService
     * @Flow\Inject()
     */
    protected $serviceUrlService;

    public function findByIdentifier(string $identifier): ?Service
    {
        return $this->serviceRepository->findByIdentifier($identifier);
    }

    public function url(?Service $service): ?string
    {
        if (!$service) {
            return null;
        }

        return $this->serviceUrlService->generateUrl($service) ?: null;
    }

    public function allowsCallOfMethod($methodName): bool
    {
        return \in_array($methodName, [ 'findByIdentifier', 'url' ]);
    }
}
