<?php declare(strict_types=1);

namespace Newland\Toubiz\Services\Neos\Controller;

use Neos\ContentRepository\Domain\Model\NodeInterface;
use Neos\Flow\Annotations as Flow;
use Neos\Flow\Mvc\Controller\ActionController;
use Neos\Flow\Mvc\View\ViewInterface;
use Newland\Toubiz\Sync\Neos\Domain\Repository\ServiceRepository;

class ServiceTeaserController extends ActionController
{

    /**
     * @var ServiceRepository
     * @Flow\Inject()
     */
    protected $serviceRepository;

    /**
     * @var NodeInterface
     */
    protected $node;

    public function initializeView(ViewInterface $view): void
    {
        /** @var NodeInterface|null $node */
        $node = $this->request->getInternalArgument('__node');
        if ($node !== null) {
            $this->node = $node;
        }
        $view->assign('node', $this->node);
    }

    public function listAction(): void
    {
        $ids = $this->node->getProperty('services') ?? [];
        $this->view->assignMultiple(
            [
                'services' => $this->serviceRepository->findByIdentifiers($ids),
                'enableSwiper' => $this->node->getProperty('displayStyle') === 'swiper',
            ]
        );
    }

    public function showAction(): void
    {
        $serviceId = $this->node->getProperty('service');
        $service = $this->serviceRepository->findByIdentifier($serviceId);

        $this->view->assignMultiple([ 'service' => $service ]);
    }
}
