<?php declare(strict_types=1);
namespace Newland\Toubiz\Search\Neos\Domain\Search;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

abstract class AbstractSearch
{
    /** @var array */
    protected $configuration;

    public function __construct(array $configuration = [])
    {
        $this->configuration = $configuration;
    }

    /**
     * Strips invalid characters from given string.
     *
     * @param string $string
     * @return string
     */
    protected function stripInvalidCharacters(string $string): string
    {
        return str_replace(
            ['"', "'"],
            '',
            $string
        );
    }
}
