<?php declare(strict_types=1);
namespace Newland\Toubiz\Search\Neos\Domain\Model;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Doctrine\ORM\Mapping as ORM;
use Neos\Flow\Annotations as Flow;

/**
 * Search index model.
 *
 * Represents a single entry in the whole index.
 *
 * @Flow\Entity
 * @ORM\Table(indexes={
 *   @ORM\Index(name="identifier", columns={"identifier"}),
 *   @ORM\index(name="scope", columns={"scope"}),
 *   @ORM\Index(name="fulltext_content", columns={"content"}, flags={"fulltext"})
 * })
 */
class SearchIndex
{
    /**
     * Document node identifier.
     * @var string|null
     * @ORM\Column(nullable=TRUE)
     */
    protected $identifier;

    /**
     * Indexer source for this entry.
     * @ORM\Column(nullable=TRUE)
     * @var string|null
     */
    protected $source;

    /**
     * The indexed content.
     * @var string
     * @ORM\Column(type="text")
     */
    protected $content;

    /**
     * Search result title.
     * @var string|null
     * @ORM\Column(nullable=TRUE)
     */
    protected $title;

    /**
     * Search result abstract.
     * @var string|null
     * @ORM\Column(type="text", nullable=TRUE)
     */
    protected $description;

    /**
     * @var string|null
     * @ORM\Column(nullable=TRUE)
     */
    protected $scope;

    /**
     * @var string|null
     * @ORM\Column(nullable=TRUE)
     */
    protected $language;

    public function setIdentifier(?string $identifier): void
    {
        $this->identifier = $identifier;
    }

    public function getIdentifier(): ?string
    {
        return $this->identifier;
    }

    public function setSource(?string $source): void
    {
        $this->source = $source;
    }

    public function getSource(): ?string
    {
        return $this->source;
    }

    public function setContent(string $content): void
    {
        $this->content = $content;
    }

    public function getContent(): string
    {
        return $this->content;
    }

    public function setTitle(?string $title): void
    {
        $this->title = $title;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setScope(?string $scope): void
    {
        $this->scope = $scope;
    }

    public function getScope(): ?string
    {
        return $this->scope;
    }

    public function setLanguage(?string $language): void
    {
        $this->language = $language;
    }

    public function getLanguage(): ?string
    {
        return $this->language;
    }
}
