<?php declare(strict_types=1);
namespace Newland\Toubiz\Search\Neos\Indexer;

/*
 * This file is part of the "toubiz-search-neos" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Interface for indexer classes.
 */
interface IndexerInterface
{
    /**
     * Main method.
     *
     * Runs the indexing routine from the conrete implementation.
     *
     * @return void
     */
    public function index(): void;

    /**
     * Post-indexing method.
     *
     * Runs after indexing.
     *
     * @return void
     */
    public function postIndex(): void;

    public function setConfiguration(array $configuration = []): void;

    /**
     * Adds listener for progress events.
     * The block will receive the number of processed records as the first argument
     * and the total number as the second argument.
     *
     * If there is no information about the total number then the second argument will be `null`.
     *
     * @param callable $block
     */
    public function onProgress(callable $block): void;

    /**
     * Returns a human readable name of the indexer.
     *
     * @return string
     */
    public function name(): string;
}
